function T = dynamic_g1_tt(T, y, x, params, steady_state, it_)
% function T = dynamic_g1_tt(T, y, x, params, steady_state, it_)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double  vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double  vector of endogenous variables in the order stored
%                                                    in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double  matrix of exogenous variables (in declaration order)
%                                                    for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double  vector of steady state values
%   params        [M_.param_nbr by 1]        double  vector of parameter values in declaration order
%   it_           scalar                     double  time period for exogenous variables for which
%                                                    to evaluate the model
%
% Output:
%   T           [#temp variables by 1]       double  vector of temporary terms
%

assert(length(T) >= 265);

T = World_Economy_Cartel_Fracking_VD.dynamic_resid_tt(T, y, x, params, steady_state, it_);

T(123) = exp(y(28))*T(32)*T(100);
T(124) = T(40)+T(39)+T(38)*y(24)*(-(exp(y(28))*T(24)));
T(125) = (-(T(23)*exp(y(38))*exp(y(107))));
T(126) = (exp(y(29))*T(34)-exp(y(29))*exp(y(29)))/(T(34)*T(34));
T(127) = (-(exp(y(30))*exp(y(29))))/(T(34)*T(34));
T(128) = y(103)*(-T(127))+params(25)*y(144)*T(127);
T(129) = (-(exp(y(29))*exp(y(52))))/(T(34)*T(34));
T(130) = y(103)*(-T(129))+params(25)*y(144)*T(129);
T(131) = (exp(y(30))*T(34)-exp(y(30))*exp(y(30)))/(T(34)*T(34));
T(132) = (-(exp(y(30))*exp(y(52))))/(T(34)*T(34));
T(133) = y(103)*(-T(132))+params(25)*y(144)*T(132);
T(134) = (T(32)*T(33)-T(32)*T(32))/(T(33)*T(33));
T(135) = (-(exp(y(32))*T(32)))/(T(33)*T(33));
T(136) = y(104)*(-T(135))+params(25)*y(145)*T(135);
T(137) = (-(exp(y(53))*T(32)))/(T(33)*T(33));
T(138) = y(104)*(-T(137))+params(25)*y(145)*T(137);
T(139) = (exp(y(32))*T(33)-exp(y(32))*exp(y(32)))/(T(33)*T(33));
T(140) = (-(exp(y(32))*exp(y(53))))/(T(33)*T(33));
T(141) = y(104)*(-T(140))+params(25)*y(145)*T(140);
T(142) = (-(exp(y(6))*exp((-y(51)))*exp(y(10))));
T(143) = T(49)+params(25)*y(125)*exp(y(34))*params(6)*params(5)*exp(params(5)*y(38))+T(57);
T(144) = (-(exp(y(6))*(-(exp((-y(51)))*exp(y(10))))));
T(145) = T(47)+T(53)+params(25)*y(125)*exp(y(33))*params(6)*params(5)*params(5)*exp(params(5)*y(37));
T(146) = T(38)*y(24)*T(24)*params(6)*params(5)*(params(5)-1)*exp(y(11)*(params(5)-1))+T(38)*y(22)*(-(T(24)*(exp(y(28))*exp(y(11))+y(40)*(-exp(y(11)))-params(6)*params(5)*exp(params(5)*y(11)))));
T(147) = (-(T(23)*(exp(y(38))*exp(y(107))+y(108)*(-exp(y(38)))-params(6)*params(5)*params(5)*exp(params(5)*y(38)))));
T(148) = y(76)*T(147);
T(149) = T(8)*getPowerDeriv(T(8),T(13),2);
T(150) = T(8)*T(149);
T(151) = T(58)+T(150);
T(152) = T(8)*getPowerDeriv(T(8),T(1),2);
T(153) = T(8)*T(152);
T(154) = T(59)+T(153);
T(155) = params(11)*T(154);
T(156) = getPowerDeriv(T(9),T(10),2);
T(157) = exp(y(110))*getPowerDeriv(exp(y(110)),T(1),1);
T(158) = getPowerDeriv(T(72),T(10),2);
T(159) = exp(y(43))*getPowerDeriv(exp(y(43)),T(11),2);
T(160) = exp(y(43))*T(159);
T(161) = T(61)+T(160);
T(162) = y(71)*(-(T(19)*T(16)*T(62)*T(90)+T(5)*T(19)*T(62)*T(92)))+y(70)*(-(T(17)*T(3)*T(63)*T(92)+T(3)*T(16)*T(63)*T(94)));
T(163) = (-(T(5)*T(19)*T(16)*T(61)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(50))));
T(164) = (-(T(17)*T(3)*T(16)*T(61)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(50))));
T(165) = y(71)*T(163)+y(70)*T(164);
T(166) = exp(y(111))*getPowerDeriv(exp(y(111)),T(11),1);
T(167) = (1-params(11))*(1-params(3))*exp(T(1)*y(116))*T(166);
T(168) = (-(T(65)*(T(80)*T(79)*(1-params(11))*params(3)*exp(T(1)*y(116))*T(166)+T(82)*T(77)*(1-params(11))*params(3)*exp(T(1)*y(116))*T(166))));
T(169) = exp(y(13))*getPowerDeriv(exp(y(13)),params(3),1);
T(170) = T(5)*T(169);
T(171) = T(2)*T(96)*T(170);
T(172) = exp(y(13))*getPowerDeriv(exp(y(13)),params(3)-1,1);
T(173) = (-(T(5)*(T(16)*T(62)*T(172)+T(19)*T(62)*T(91)*T(170))));
T(174) = T(16)*T(63)*T(169)+T(3)*T(63)*T(91)*T(170);
T(175) = getPowerDeriv(T(6),T(13),2);
T(176) = T(91)*T(90)*T(169)+T(3)*T(90)*T(170)*T(175);
T(177) = T(15)*T(16)*T(169)+T(3)*T(15)*T(91)*T(170);
T(178) = getPowerDeriv(T(6),T(1),2);
T(179) = T(2)*(T(96)*T(90)*T(169)+T(3)*T(90)*T(170)*T(178));
T(180) = (-(exp(y(45)*(1-params(3)))*T(1)*exp(T(1)*y(50))*params(3)*exp(y(13)*params(3))));
T(181) = T(16)*T(104)*T(172)+T(19)*T(104)*T(91)*T(170);
T(182) = T(16)*T(105)*T(169)+T(3)*T(105)*T(91)*T(170);
T(183) = T(20)*getPowerDeriv(T(20),params(3),2);
T(184) = T(20)*T(183);
T(185) = T(66)+T(184);
T(186) = getPowerDeriv(T(68),T(1),2);
T(187) = T(64)*(T(69)*T(65)*T(185)+T(65)*T(66)*T(65)*T(66)*T(186));
T(188) = getPowerDeriv(T(68),T(13),2);
T(189) = T(78)*T(65)*T(185)+T(65)*T(66)*T(65)*T(66)*T(188);
T(190) = T(20)*getPowerDeriv(T(20),params(3)-1,2);
T(191) = T(20)*T(190);
T(192) = T(82)+T(191);
T(193) = exp(y(14))*getPowerDeriv(exp(y(14)),1+params(8),1);
T(194) = (-(params(9)*T(193)/(1+params(8))));
T(195) = getPowerDeriv(T(27),(-params(14)),1);
T(196) = T(194)*T(195);
T(197) = (-((-(params(1)*T(87)*T(196)))/(T(28)*T(28))));
T(198) = (-((-(params(1)*T(100)*T(196)))/(T(28)*T(28))));
T(199) = T(4)*getPowerDeriv(T(4),1+params(8),2);
T(200) = T(4)*T(199);
T(201) = T(84)+T(200);
T(202) = (-(params(9)*T(201)/(1+params(8))));
T(203) = getPowerDeriv(T(25),(-params(14)),2);
T(204) = T(86)*T(202)+T(85)*T(85)*T(203);
T(205) = T(4)*getPowerDeriv(T(4),1-params(3),2);
T(206) = T(4)*T(205);
T(207) = T(90)+T(206);
T(208) = T(91)*T(3)*T(207)+T(3)*T(90)*T(3)*T(90)*T(175);
T(209) = (-(T(90)*T(19)*T(18)*T(92)+T(16)*T(18)*T(19)*T(207)+T(90)*T(19)*T(18)*T(92)+T(5)*T(19)*T(18)*T(208)));
T(210) = T(4)*getPowerDeriv(T(4),(-params(3)),2);
T(211) = T(4)*T(210);
T(212) = T(94)+T(211);
T(213) = (-(T(3)*T(15)*T(92)*T(94)+T(17)*T(3)*T(15)*T(208)+T(3)*T(15)*T(92)*T(94)+T(3)*T(15)*T(16)*T(212)));
T(214) = T(2)*(T(96)*T(3)*T(207)+T(3)*T(90)*T(3)*T(90)*T(178));
T(215) = T(26)*T(26)*T(26)*T(26);
T(216) = (-((T(26)*T(26)*(-(T(99)*T(204)))-(-(T(87)*T(99)))*(T(26)*T(87)+T(26)*T(87)))/T(215)));
T(217) = exp(y(46))*T(85)*T(203);
T(218) = T(26)*T(26)*(-(T(99)*T(217)))-(-(T(99)*T(100)))*(T(26)*T(87)+T(26)*T(87));
T(219) = (-(T(90)*T(19)*T(16)*T(104)+T(5)*T(19)*T(92)*T(104)));
T(220) = y(71)*T(219);
T(221) = y(70)*(-(T(94)*T(3)*T(16)*T(105)+T(17)*T(3)*T(92)*T(105)));
T(222) = T(3)*T(90)*T(96)*T(106);
T(223) = T(87)*T(110);
T(224) = exp(y(112))*getPowerDeriv(exp(y(112)),1-params(3),1);
T(225) = T(64)*(T(69)*T(66)*T(224)+T(65)*T(66)*T(186)*T(67)*T(224));
T(226) = exp(y(112))*getPowerDeriv(exp(y(112)),(-params(3)),1);
T(227) = T(78)*T(66)*T(224)+T(65)*T(66)*T(188)*T(67)*T(224);
T(228) = exp(y(112))*getPowerDeriv(exp(y(112)),1+params(8),1);
T(229) = (-(params(9)*T(228)/(1+params(8))));
T(230) = getPowerDeriv(T(98),(-params(14)),1);
T(231) = params(1)*T(229)*T(230);
T(232) = (-((-(params(1)*T(87)*exp(y(15))*T(195)))/(T(28)*T(28))));
T(233) = (-((-(params(1)*T(100)*exp(y(15))*T(195)))/(T(28)*T(28))));
T(234) = T(85)*exp(y(46))*T(203);
T(235) = T(26)*T(100)+T(26)*T(100);
T(236) = (-((T(26)*T(26)*(-(T(99)*T(234)))-(-(T(87)*T(99)))*T(235))/T(215)));
T(237) = T(100)+exp(y(46))*exp(y(46))*T(203);
T(238) = exp(y(48))*getPowerDeriv(exp(y(48)),T(22),2);
T(239) = exp(y(48))*T(238);
T(240) = T(102)+T(239);
T(241) = (-(exp(y(45)*(1-params(3)))*exp(y(13)*params(3))*T(1)*T(1)*exp(T(1)*y(50))));
T(242) = (-(T(17)*T(3)*T(16)*T(12)*(1-params(11))*(1-params(3))*T(1)*T(1)*exp(T(1)*y(50))));
T(243) = T(7)*(1-params(11))*T(1)*T(1)*exp(T(1)*y(50));
T(244) = T(65)*T(66)*T(69)*(1-params(11))*T(1)*exp(T(1)*y(116));
T(245) = T(75)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(116));
T(246) = T(66)*T(77)*T(245)+T(67)*T(79)*T(245);
T(247) = T(80)*T(79)*T(75)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(116))+T(82)*T(77)*T(75)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(116));
T(248) = getPowerDeriv(exp(y(65)-y(51)),params(5)-1,2);
T(249) = (-(T(32)*params(6)*(exp(y(65)-y(51))*T(109)+(-exp(y(65)-y(51)))*(-exp(y(65)-y(51)))*T(248))));
T(250) = y(92)*T(142)+y(86)*T(144);
T(251) = (-(T(32)*params(6)*((-exp(y(65)-y(51)))*T(109)+exp(y(65)-y(51))*(-exp(y(65)-y(51)))*T(248))));
T(252) = params(25)*y(129)*(-(exp(y(33))*(-(exp(y(37))*(-exp((-y(117))))))))+params(25)*y(135)*(-(exp(y(33))*exp(y(37))*(-exp((-y(117))))));
T(253) = (exp(y(52))*T(34)-exp(y(52))*exp(y(52)))/(T(34)*T(34));
T(254) = (exp(y(53))*T(33)-exp(y(53))*exp(y(53)))/(T(33)*T(33));
T(255) = y(91)*T(119)+y(85)*T(120)+y(73)*exp(y(19))*params(22)*params(21)*exp(params(21)*y(56));
T(256) = T(38)*y(25)*(-(T(24)*(exp(y(28))*exp(y(56))+y(57)*(-exp(y(56)))-params(22)*params(21)*params(21)*exp(params(21)*y(56)))));
T(257) = T(38)*y(25)*(-(T(24)*(-exp(y(56)))));
T(258) = params(25)*y(134)*(-(exp(y(118))*exp(y(54))))+params(25)*y(125)*exp(y(54))*params(22)*params(21)*exp(params(21)*y(118))+params(25)*y(128)*(-(exp(y(54))*(-exp(y(118)))));
T(259) = (-exp(y(65)-y(51)))*T(109)+(-exp(y(65)-y(51)))*exp(y(65)-y(51))*T(248);
T(260) = (-(T(32)*params(6)*T(259)));
T(261) = (-(T(32)*params(6)*(exp(y(65)-y(51))*T(109)+exp(y(65)-y(51))*exp(y(65)-y(51))*T(248))));
T(262) = T(38)*(-(T(24)*exp(y(28))*exp(y(56))));
T(263) = T(38)*(-(T(24)*(exp(y(28))*exp(y(56))+y(57)*(-exp(y(56)))-params(22)*params(21)*exp(params(21)*y(56)))));
T(264) = params(25)*(-(exp(y(33))*(-(exp((-y(117)))*exp(y(37))))));
T(265) = params(25)*(-(exp(y(33))*exp((-y(117)))*exp(y(37))));

end
